@extends('layouts.app', ['pageSlug' => 'test'])
@push('style')
      <link rel="stylesheet" href="https://netdna.bootstrapcdn.com/bootstrap/3.3.2/css/bootstrap.min.css">
@endpush
@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">
         @if ($message = Session::get('success'))
            <div class="btn btn-success btn-block btn-sm custom_message text-left">
                <button type="button" class="close" data-dismiss="alert">×</button>    
                <strong>{{ $message }}</strong>
            </div>
          @endif
        <div class="card">  
            <div class="card-header">
                <h5 class="title">Add test</h5>
            </div>
            <div class="card-body">
              {{Form::open([ 'id'=>'test','enctype' => 'multipart/form-data','onsubmit'=>'return submitfunction();'])}}
            <div class="row">
            <div class="form-group col-md-6">
              <label for="">Test Name <span class="mandatory">* </span></label>
              {{Form::text('test_name',$test->test_name,array('autocomplete' => 'off' ,'id' =>'test_name','class' => 'form-control','placeholder' => 'Enter test'))}}
              @if($errors->has('test_name'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('test_name')}} </p>
              @endif
            </div>
            <div class="form-group col-md-6">
              <label for="">Test Hours <span class="mandatory">* </span></label>
              {{Form::text('hours',$test->hours,array('autocomplete' => 'off' ,'id' =>'hours','readonly' => 'readonly','class' => 'form-control','placeholder' => 'Enter Total Hour'))}}
               <p style="color: darkgrey;font-size: 11px;padding-left: 17px;font-weight: 600;margin-top: -13px;font-style: italic;">ex: 02:30</p>
               @if($errors->has('hours'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('hours')}} </p>
              @endif
            </div>
            </div>
            <div class="row">
              <div class="form-group col-md-6">
            <label>Test Type <span class="mandatory">*</span></label>
              <select class="form-control" name="test_type" id="test_type" onchange="testtype(this.value)">
                  <option value="">[-Select-]</option>
                 
                  <option value="comprehensive">Comprehensive Test</option>
                   <option value="category">Category Test</option>
              </select>
              @if($errors->has('test_type'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('test_type')}} </p>
              @endif
            </div><!-- Field -->
           <div class="input-text form-group col-md-6 catcom">
              <label>Category <span class="mandatory">* </span></label>
             <select  class="form-control select2 comprehensive" name="category[]" id="category" multiple="">
             <option value="">select</option>
              <?php foreach($categories as $cat){?>
            <option value="<?php echo $cat->id;?>" maxquestions="<?php echo $cat->max_questions;?>"><?php echo $cat->category_name?>-<?php echo $cat->comprehensive_test_percentage?> Percentage</option>
                                    

                                <?php } ?>   
                
              </select>

              @if($errors->has('category'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;" > {{   $errors->first('category')}} </p>
              @endif
               <p style="color:red;font-size: 12px;font-weight: 600;" class="caterror">  </p>
            </div><!-- Field -->
          </div>
           <div class="row">
            <div class="form-group col-md-6">
            <label>Question Type <span class="mandatory">*</span></label>
              <select class="form-control select2" name="question_usedstatus[]" id="question_usedstatus" multiple="">
                 <!--  <option value="">[-Select-]</option> -->
                  <option value="1">Used</option>
                  <option value="0">Unused</option>
              </select>
              @if($errors->has('question_usedstatus'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('question_usedstatus')}} </p>
              @endif
            </div><!-- Field -->
            <div class="form-group col-md-6">
              <label for=""> No. Of Questions <span class="mandatory">* </span></label>
              {{Form::text('no_of_question',$test->no_of_question,array('autocomplete' => 'off' ,'id' =>'no_of_question','class' => 'form-control','placeholder' => 'No. Of Questions / 256'))}}
               @if($errors->has('no_of_question'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('no_of_question')}} </p>
              @endif
            </div>
          </div>
          <div class="checked_box">
            <div id="resultDiv">
              
            </div>
          </div>

          <!-- <div class="row">
            <div class="form-group col-md-6">
              <label for="">User Limit<span class="mandatory">* </span></label>
              {{Form::text('user_limit',$test->user_limit,array('autocomplete' => 'off' ,'id' =>'user_limit','class' => 'form-control','placeholder' => 'Enter User Limit'))}}
              @if($errors->has('user_limit'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('user_limit')}} </p>
              @endif
            </div>
            <div class="form-group col-md-6">
              <label for="">Audio<span class="mandatory">* </span></label>
              <input name="audio" type="file" class="form-control" required="" accept="audio/*">
              @if($errors->has('audio'))
                <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('audio')}} </p>
              @endif
            </div>
          </div> -->
            <div class="form-group" style="margin-top: 24px;">
              <input type="submit" class="btn btn-primary" value="Submit">
            </div>

          {{Form::close()}}
          </div>
          </div>
        </div>
    </div>
</div>
<style type="text/css">
  select{
    padding: 7px 9px 6px 20px !important;
  }
  .select2-container--default .select2-selection--multiple .select2-selection__choice{
    color: #000;
  }
  input[type="radio"]{
      vertical-align: middle;
      margin-right: 6px;
  }
  .form-group input[type=file] {
    opacity: 1;
    position: unset;
    margin-bottom: 0px !important;
    height: 46px;
}
input[type="radio"], input[type="checkbox"] {
   
    width: 20px;
    display: inline-block;
    vertical-align: middle;
    margin-right: 10px;
}
.form-control[readonly] {
    background-color: #eee;
}
</style>

<script type="text/javascript">
  $(document).ready(function() {
    var lastChecked;
      $('.checked_box #resultDiv').on("click",".check",function() {
        var checkcount = $('input[name="question_id[]"]:checked').length;
        if($('#no_of_question').val()<checkcount){
          alert("Sorry, you have already selected "+$('#no_of_question').val()+" Questions!");
          lastChecked.checked = false;
        }
        lastChecked = this;
      });
    });
</script>
<script type="text/javascript">
   $(document).ready(function() {
    $('#question_usedstatus').on('change',function(){
      // alert('s');
      var no_question = $('#no_of_question').val();
      var category = $('#category').val();
      var test_type = $('#test_type').val();
      var qtype = $('#question_usedstatus').val();
       // alert(category);
       // alert(qtype);
      if(test_type=="comprehensive"){
      
        var category1 = ''+category+'';
        var nameArr = category1.split(',');
        // alert('test');
        // alert(nameArr.length);
        // if(nameArr.length=="8"){
          $('.caterror').html("");
          //alert('length');
          $.ajax({
        method:'POST',
        url: "{{url('getquestion')}}",
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        data: {no_question:no_question,category:category,qtype:qtype,test_type:test_type},
        success: function(data){
          $("#resultDiv").html(data);
          
          
        }
      });
        // }else{
        //   $('.caterror').html("Please Select All Categories");
        //   //alert("Select All Category");
        // }
       
      }
     else{
         if(category!=""){
            $.ajax({
        method:'POST',
        url: "{{url('getquestion')}}",
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        data: {no_question:no_question,category:category,qtype:qtype,test_type:test_type},
        success: function(data){
          $("#resultDiv").html(data);
          }
          });
         $('.caterror').html("");
        
     }
     else{
      $('.caterror').html("Please Select one Categories");
     }
   }
      
    });

    //Select All Checkbox
    $(document).on('click','#all_check',function(e) {
    //   alert('as');
    var value=$(".check").val();
//alert(value);
      if($(this).prop("checked")) {
        $(".check").prop("checked", true);
        //var mulcount=0;
        $('.multiplechoiceno').val('0');
        $('.check').each(function(){
          //if($(this).prop("checked")) {
            var questype=$(this).attr('questype');
            if(questype=="Multiple choice"){
            var currval=$('.multiplechoiceno').val();
            var Mc=Number(currval)+Number(1);
               $('.multiplechoiceno').val(Mc);
          }
         //console.log($(this).attr('questype'));
      //}
      });
      }else{
        $(".check").prop("checked", false);
        $('.multiplechoiceno').val(0);
      }
    });
    $(document).on('click','.check',function(e) {
            if($(".check").length == $(".check:checked").length) { 
                 //if the length is same then untick 
              $("#all_check").prop("checked", true);
              var selectques= $(".check:checked").length;
              $('.selectedques').html("Selected Questions Count :"+selectques);
              var qtype=$(this).attr("questype");
              //alert(qtype);
            }else {
                //vise versa
                $("#all_check").prop("checked", false);   
                var selectques= $(".check:checked").length;
                $('.selectedques').html("Selected Questions Count :"+selectques);         
            }
        });
    //End Select All
    $('.select2').select2();
    });
    
</script>
<script type="text/javascript">
   $(document).ready(function() {


    function minTommss(minutes){
 var sign = minutes < 0 ? "-" : "";
 var min = Math.floor(Math.abs(minutes));
 var sec = Math.floor((Math.abs(minutes) * 60) % 60);
 return sign + (min < 10 ? "0" : "") + min + ":" + (sec < 10 ? "0" : "") + sec;
}

    $('#category').on('change',function(){
      var category = $(this).val();
      $.ajax({
        method:'POST',
        url: "{{url('getcategory')}}",
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        data: {category:category},
        success: function(data){
          // console.log(JSON.parse(data)[0].max_questions);
          var test_percentage = JSON.parse(data)[0].comprehensive_test_percentage;
          $('#no_of_question').val(JSON.parse(data)[0].max_questions);
          var time = test_percentage/100*6;
          //var time = Math.round(test_percentage / 100) * 6
          //alert(time);
          //console.log(minTommss(time) );
         
          var test_type=$('#test_type').val();
          if(test_type=="category"){
            $('#hours').val(minTommss(time));
          }else{
             $('#hours').val("06:00");
             $('#no_of_question').val('256');
          }
          
       }
      });
    });
  });
   function testtype($test){
    //alert($test);
    
    $('#hours').val('');
   $('.comprehensive').val('');
    if($test=="category"){
     
      $('.comprehensive').removeAttr("multiple");
      $('.catcom').show();
    }else{
      $('.comprehensive').attr("multiple","");
      $('#hours').val('06:00');
      $('#no_of_question').val('256');
      $('.catcom').hide();
    }
   }
    
   function checkcount($val){
    //alert($val);
     var no_question = $('#no_of_question').val();
     //alert(no_question);
    if($val>no_question){
      //alert('Sorry You select more than Max Questions Count ');
      $.alert('Sorry You select more than Max Questions Count');
     // $('.check').attr('checked', false);
      $(".check").prop("checked", false);
      $("#all_check").prop("checked", false);
      $('.multiplechoiceno').val('0');
    }
    
   }
   function submitfunction(){
       $numberofquestion = $('#no_of_question').val();
       $test_type = $('#test_type').val();
       var multiplecurrentno=$('.multiplechoiceno').val();
       $totalnumber=$numberofquestion/100*85;
       var mulneedper=Math.round($totalnumber);
       if($test_type=="comprehensive"){
       var c1count = $('.selcat_1:checked').length;
       var totalc1=$('.cat_1').val();
       var c2count = $('.selcat_2:checked').length;
       var totalc2=$('.cat_2').val();
       var c3count = $('.selcat_3:checked').length;
       var totalc3=$('.cat_3').val();
       var c4count = $('.selcat_4:checked').length;
       var totalc4=$('.cat_4').val();
       var c5count = $('.selcat_5:checked').length;
       var totalc5=$('.cat_5').val();
       var c6count = $('.selcat_6:checked').length;
       var totalc6=$('.cat_6').val();
       var c7count = $('.selcat_7:checked').length;
       var totalc7=$('.cat_7').val();
       var c8count = $('.selcat_8:checked').length;
       var totalc8=$('.cat_8').val();
      //alert(c1count+totalc1);
      
       //alert(mulneedper);
      if((c1count==totalc1)&&(c2count==totalc2)&&(c3count==totalc3)&&(c4count==totalc4)&&(c5count==totalc5)&&(c6count==totalc6)&&(c7count==totalc7)&&(c8count==totalc8)){
        //alert('success');
        if(multiplecurrentno>=mulneedper)
        {
          
             $.confirm({
    title: 'Confirm!',
    content: ' Please check the form once. Because did not provide edit to the form. Are you sure you want to submit this form?',
    buttons: {
        confirm: function () {
           //$.alert('submit!');
            $.alert('success');
            return true;
           
        },
        cancel: function () {
            $.alert('Canceled!');
            return false;
        }
        
    }
    });
        }else{
           $.alert("As Per Number of Questions Atleast "+mulneedper+" Questions select in multiple choice category");
            return false;
        }


      
      }else{
        
        $.alert('Please select each category wise questions count');
        return false;
      }
    }
    else{

       if(multiplecurrentno>=mulneedper)
        {
          
             $.confirm({
    title: 'Confirm!',
    content: ' Please check the form once. Because did not provide edit to the form. Are you sure you want to submit this form?',
    buttons: {
        confirm: function () {
           //$.alert('submit!');
            $.alert('success');
            return true;
           
        },
        cancel: function () {
            $.alert('Canceled!');
            return false;
        }
        
    }
    });
        }else{
           $.alert("Atleast "+mulneedper+" Questions select in multiple choice category");
            return false;
        }

    }
      
    //alert("Please check the form once. Because did not provide edit to the form. Are you sure you want to submit this form?");

   }
   function quesper($id){
    //alert($id);
     var chkPassport = document.getElementById("chk-"+$id+"");
     // alert(chkPassport);
     // alert("chk-"+$id+"");
     var questype=$("#chk-"+$id+"").attr('questype');
     //alert(questype);
        if (chkPassport.checked) {
          if(questype=="Multiple choice"){
            var currval=$('.multiplechoiceno').val();
            var Mc=Number(currval)+Number(1);
               $('.multiplechoiceno').val(Mc);
          }
            
            //alert("CheckBox checked.");

        } else {
          if(questype=="Multiple choice"){
            var currval=$('.multiplechoiceno').val();
               var Mc=Number(currval)-Number(1);
               $('.multiplechoiceno').val(Mc);
          }
            //alert("CheckBox not checked.");
        }
    
   }
   
$('#no_of_question').on('change', function() {
  var test_type=$("#test_type").val();
  var value=$('#no_of_question').val();
  if(test_type=="category"){
     var maxquestion=$('#category').find('option:selected').attr('maxquestions');
     //alert(maxquestion);
     
     if(Number(value)>Number(maxquestion)){
      $('#no_of_question').val(0);
      $.alert('This Category allowed Maximum'+maxquestion+'');
     }
  }else{
    if(Number(value)>256){
      $('#no_of_question').val(0);
      $.alert('Comprehensive allowed Maximum '+maxquestion+'');
     }
  }
 
  //alert( this.value );
});
</script>
@endsection

