<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Test;
use App\Models\Questions;
use App\Category;
use App\Weightages;
use App\TestSetting;
use Illuminate\Validation\Rule;
use DB;
use Validator;

class TestController extends Controller
{
     public function add()
    {  
      $this->data['test'] = $test = new Test;
      //$this->data['categories'] = Category::pluck('category_name', 'id');
     $this->data['categories'] = DB::table('categories')->where('status','0')->get();
     // $this->data['categories1'] = DB::table('categories')->where('status','0')->get()->toArray();
      $this->data['weightages'] = Weightages::pluck('weightage_title', 'id');
        return view('test.add', $this->data);
    }
    public function list()
    {  
        $tests= Test::toBase()->get();
        return view('test.list',compact('tests'));
        
    }
    public function save(Request $request) {
      
      // dd($request->all());
    //   exit();
    DB::beginTransaction();
    try {
      $rules = [
              'test_name' => 'required|min:2|unique:tests',
              'hours' => 'required',
              'question_usedstatus' => 'required',
              // 'category' => 'required',
              'test_type'=> 'required',
              'no_of_question' => 'required|integer|between:1,256',
              
              // 'user_limit' => 'required',
          ];

          $errorMessage = [
              'required' => 'Enter :attribute'
          ];
        //Move AUDIO

        // $audioName = time().'.'.$request->audio->extension();  
        // $request->audio->move(public_path('audio'), $audioName);

        //END AUDIO FILE
        $this->validate($request, $rules, $errorMessage);
        $test = new Test;
        $test->test_name = $request->test_name;
        $test->test_type = $request->test_type;
        $test->question_usedstatus = implode(',',$request->question_usedstatus);
        $test->hours = $request->hours;
        if($test->test_type=="category"){
          $cat=$request->category;
        }else{
           $cat=Category::pluck('id')->toArray();

        }
        //print_r($cat);
        $test->category = implode(',',$cat);
        $test->no_of_question = $request->no_of_question;
        // $test->user_limit = $request->user_limit;
        // $test->audio = $audioName;
        $test->save();
                $test_id= $test->id;

                DB::table('test_questions')->insert(array('test_id' => $test_id,'question_id' => implode(',', $request->question_id)));
                  DB::commit();
                  $request->session()->flash('success', 'Test added successfully!');
              return redirect('/listtest')->with('success', 'Test added successfully!');
                            

    } catch (Exception $e) {
      DB::rollBack();
      return response()->json(['success' => false, 'errors' => ['Exception Error' => $e->getMessage()]]);
    }

  }
  public function delete($id)
    {
        DB::delete('delete from tests where id = ?',[$id]);
        DB::delete('delete from test_questions where test_id = ?',[$id]);
        return redirect('/listtest')->with('success', 'Test deleted successfully!');
    }
    public function getcategory(Request $request)
    {
     $datas = Category::Where('id', $request->get('category'))
              ->get()->toArray();
     echo  json_encode($datas);
    }
  public function getquestion(Request $request)
    {
     
     // $datas = Questions::WhereIn('questions.category', $request->get('category'))
     //          ->Where('questions.used_status', $request->get('qtype'))
     //          ->get()->toArray();
     // print_r($datas);exit();

     //echo  json_encode($datas);
       //echo $category=$request->get('category');
      //echo $request->get('qtype');
      //echo $request->get('category');

      //print_r($request->get('category'));

       if($request->get('test_type')!="comprehensive"){
        $category=array($request->get('category'));
       }else{
        $cat=Category::pluck('id');
     // print_r($cat);
         //$category=$request->get('category');
         $category=$cat;
       }
      $result = Questions::orderBy('questions.id', 'asc')
                
              ->leftjoin('categories', 'questions.category', '=', 'categories.id')
              ->leftjoin('question_categories', 'questions.question_type', '=', 'question_categories.id')
              ->select('questions.*','categories.category_name','categories.comprehensive_test_percentage','question_categories.question_category')
              ->Where('questions.status',0)
            ->WhereIn('questions.category',$category)
             ->WhereIn('questions.used_status', $request->get('qtype'))
            ->get()->toArray();
            // print_r($result);
            // exit();
            $questionlist=array();
            $numberofquestion=$request->get('no_question');
            foreach ($result as $key => $value) {
              $per=$value['comprehensive_test_percentage'];
              $totalnumber=$numberofquestion/100*$per;
            $numberquestion[$value['category_name']]=round($totalnumber);
             $questionlist[$value['category_name']][]=$value;
             
            }
      echo '<input value="" class="form-control all_check" type="checkbox" id="all_check" onchange="checkcount('.count($result).')"/> Select All ('.count($result).')<div class="selectedques"></div><input type="hidden" class="multiplechoiceno" value="0">
      <table class="table table-striped table-bordered">
        <thead>
          <tr>
            <th scope="col">#</th>

            <th scope="col">Questions</th>
             <th scope="col">Questions type</th>
          </tr>
        </thead>
        <tbody>';
        $sno="1";
        foreach($questionlist as $key => $value){
          
           
             if($request->get('test_type')=="comprehensive"){
               $type='- '.$numberquestion[$key].'  Questions Only Select this category';
             }else{$type="";}
          echo  '<tr><th colspan="3">'.$key.' '.$type.'</th><input type="hidden" class="cat_'.$sno.'" value="'.$numberquestion[$key].'"></tr>';

           foreach($value as $key1 => $value1){
                 echo '<tr>
                 <td ><input value="'.$value1['id'].'" class="form-control check selcat_'.$sno.'" questype="'.$value1['question_category'].'" type="checkbox" id="chk-'.$value1['id'].'" name="question_id[]" onclick="quesper('.$value1['id'].')" /> </td>
                
              <td>'.$value1['question'].'</td>
              <td>'.$value1['question_category'].'</td>
              </tr>';
        }
        $sno++;
       }
 echo '</tbody>
</table>';
             //print_r($questionlist);
            //print_r($numberquestion);
    }
     public function teststatusupdate(Request $request){
   
     $request->status;
     if($request->status=="inactive"){
      $affected = DB::table('tests')
               ->where('test_type','comprehensive')
               ->update(['status' => "IA"]);
     }
    
     $status=($request->status=='active')?'IA':'A';
     $test = Test::find($request->id);
     $test->status = $status;
     $test->update();
     
      echo "Updated successfully";
     }
     public function listaudio()
    {
        $get_tests_audio= TestSetting::toBase()->get();
        return view('test.audio_list',compact('get_tests_audio'));
    }
    public function addaudio()
    {  
      $this->data['test'] = $test = new TestSetting;
      return view('test.audio_add', $this->data);
    }
    public function saveaudio(Request $request) {
      
     // dd($request->all());
    DB::beginTransaction();
    try {
     
        // $rules = [
        //       'wrongques_song' => 'required',
        //       'rightques_song' => 'required',
        //     ];
        //   $errorMessage = [
        //       'required' => 'Enter :attribute'
        //   ];

$audioName = time().$request->file('wrongques_song')->getClientOriginalName();
$request->wrongques_song->move(public_path('testsetting'), $audioName);
        //dd($audioName);exit();
        //Right Ans Audio
$audioName1 = time().$request->file('rightques_song')->getClientOriginalName();
$request->rightques_song->move(public_path('testsetting'), $audioName1);

        //END AUDIO FILE
        // $this->validate($request, $rules, $errorMessage);
        $tests_settings= TestSetting::toBase()->get();

      if(count($tests_settings)>0){
          DB::table('test_setting')  // find your user by their email
        ->limit(1)  // optional - to ensure only one record is updated.
        ->update(array('wrongques_song' => $audioName,'rightques_song' => $audioName1)); 
      }else{
        $test = new TestSetting;
        $test->wrongques_song = $audioName;
        $test->rightques_song = $audioName1;
        $test->save();
      }
               
        DB::commit();
         $request->session()->flash('success', 'Audio added successfully!');
        return redirect('/listaudio')->with('success', 'Audio added successfully!');
        

    } catch (Exception $e) {
      DB::rollBack();
      return response()->json(['success' => false, 'errors' => ['Exception Error' => $e->getMessage()]]);
    }

     } 
}
