@extends('layouts.app', ['pageSlug' => 'userlist'])
@push('style')
<link rel="stylesheet" type="text/css" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
@endpush
@section('content')
<div class="container">
    <div class="row ">
        <div class="col-md-12">

          @if(session()->has('message'))
            <p class="btn btn-success btn-block btn-sm custom_message text-left">{{ session()->get('message') }}</p>
          @endif

          <div class="card ">
            <div class="card-header">
                <div class="row">
                    <div class="col-8">
                        <h4 class="card-title">User List</h4>
                    </div>
                    <div class="col-4 text-right">
                        <a href="{{ route('adduser') }}" class="btn btn-sm btn-primary">Add User</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                
                <div class="">
                    <table class="table tablesorter " id="">
                        <thead class=" text-primary">
                            <tr>
                            <th scope="col">No</th>
                            <th scope="col">Name</th>
                            <th scope="col">Email</th>
                            <th scope="col">ACTION</th>
                        </tr></thead>
                        <tbody>
                          @forelse ($users as $user)
                        <tr>
                          <td>{{ $loop->index + 1 }}</td>
                          <td>{{ $user->name }}</td>
                          <td>{{ $user->email }}</td>
                         
                          <td>
                          <a href="{{ route('edituser',$user->id) }}" class="btn btn-sm btn-outline-primary py-0">Edit</a>
                          <!-- <a  href="deleteuser/{{ $user->id }}" class="btn btn-sm btn-outline-danger py-0" onclick="return confirm('Are you sure, you want to delete it?')">Delete</a> -->
                          <a style="margin-left: 10px;" href="deleteuser/{{ $user->id }}" class="btn btn-sm btn-outline-danger py-0 userdel{{ $user->id }}"  onclick="confirmpage('userdel<?php echo $user->id;?>');return false;">Delete</a>
                          </td>
                        </tr>
                         @empty
                        <tr><td colspan="4" class="text-center"> No User found!</td></tr>
                        @endforelse
                        </tbody>
                       
                    </table>
                </div>
            </div>
        </div>
        </div>
    </div>
</div>
@endsection