<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Questions;
use DB;
class QuestionsController extends Controller
{
   public function index(){
    $questions= Questions::leftJoin("categories as cat", "cat.id", '=', "questions.category")
        ->leftjoin('weightages', 'weightages.id', '=', 'questions.weightage_type')
        ->leftjoin('question_categories', 'question_categories.id', '=', 'questions.question_type')
        ->select('questions.*','cat.category_name','weightage_title','question_category')
        ->where('questions.status', '0')
        ->get();
     return view('questions.questionslist',compact('questions'));
   }
   public function addquestions(){
   	$categories = DB::table('categories')->where('status','0')->get();
   	$weightages = DB::table('weightages')->where('status','0')->get();
   	$questions_categories = DB::table('question_categories')->where('status','0')->get();
   
     return view('questions.addquestions',compact(['categories','weightages','questions_categories']));
   }
   public function gettagcategories($id)
   {
        $subcategories = DB::table("categories")->where("id",$id)->pluck("tag_questions","id")->first();
        $sub=explode(',',$subcategories);
        $tagcategories = DB::table('tags')
                    ->whereIn('id',$sub)
                    ->pluck("name","id");
                    //->get();

        

        echo  json_encode($tagcategories);
   }
   public function savequestion(Request $request){
   	 
     $rules = [
          'question'       => 'required|min:2|unique:questions',
          'category'       => 'required',
          'weightage_type' => 'required',
          'question_type'  => 'required',
          'ans'            => 'required',
          'explanation'    => 'required'];

      $errorMessage = [
          'required' => 'Enter your :attribute first.'
      ];

      $this->validate($request, $rules, $errorMessage);
      if($request->get('tags')!=''){
      	$tags=implode(',',$request->get('tags'));
      }else{$tags="";}
      
       if($request->get('optiontype')=="text"){
        $questionoption=$request->get('options');
        $options=array();
        foreach($questionoption as $key => $value){
        	$sno=$key+1;
          $options +=array('option'.$sno.''=>$value);
        }
      }else{
      	//$files = [];
        if($request->hasfile('options'))
         {
         	$options=array();
            foreach($request->file('options') as $key => $file)
            {
            	$sno=$key+1;
                $name = time().rand(1,100).'.'.$file->extension();
                $file->move(public_path('images'), $name);  
                $options +=array('option'.$sno.''=>$name);
                //$files[] = $name;  
            }
         }
         //print_r($files);
      	
      	
      }

      Questions::create([
         'question'      => $request->get('question'),
         'category'      => $request->get('category'),
          'tags'          =>$tags,
          'weightage_type'=>$request->get('weightage_type'),
          'options'          =>json_encode($options),
          'question_type'=>$request->get('question_type'),
          'optiontype'=>$request->get('optiontype'),
          'ans'          =>$request->get('ans'),
          'notes'        =>$request->get('notes'),
          'explanation'  =>$request->get('explanation')
      ]);

    
     $this->meesage('message','Questions created successfully!');
      //return redirect()->back();
      return redirect('questions');
   }
   public function editquestion(Questions $question)
    { 
    	// echo "<pre>";
    	// print_r($question);

    	// exit();
    $categories = DB::table('categories')->where('status','0')->get();
   	$weightages = DB::table('weightages')->where('status','0')->get();
   	$questions_categories = DB::table('question_categories')->where('status','0')->get();
    $subcategories = DB::table("categories")->where("id",$question->category)->pluck("tag_questions","id")->first();
    $sub=explode(',',$subcategories);
    $tagcategories = DB::table('tags')
                    ->whereIn('id',$sub)
                    //->pluck("name","id");
                    ->get();

     return view('questions.editquestions',compact(['categories','weightages','questions_categories','question','tagcategories']));
         
    }
   public function updatequestions(Request $request, Questions $question)
    { 
    	$id=$question->id;
    	 $rules = [
          'question'       => 'required|min:2|unique:questions,id,'.$id,
          'category'       => 'required',
          'weightage_type' => 'required',
          'question_type'  => 'required',
          'ans'            => 'required',];

      $errorMessage = [
          'required' => 'Enter your :attribute first.'
      ];

      $this->validate($request, $rules, $errorMessage);
      if($request->get('tags')!=''){
      	$tags=implode(',',$request->get('tags'));
      }else{$tags="";}
      
       if($request->get('optiontype')=="text"){
        $questionoption=$request->get('options');
        $options=array();
        foreach($questionoption as $key => $value){
        	$sno=$key+1;
          $options +=array('option'.$sno.''=>$value);
        }
      }else{
      	//$files = [];
        if($request->hasfile('options'))
         {
         	$options=array();
            foreach($request->file('options') as $key => $file)
            {
            	$sno=$key+1;
                $name = time().rand(1,100).'.'.$file->extension();
                $file->move(public_path('images'), $name);  
                $options +=array('option'.$sno.''=>$name);
                //$files[] = $name;  
            }
         }else{
         	 $test = DB::table('questions')->find($id);
             $options=json_decode($test->options,true);

         	 //$options=$request->get('oldoptions');
         }
         //print_r($files);
      	
      	
      }
     
      $question->update([
         'question'      => $request->get('question'),
         'category'      => $request->get('category'),
          'tags'          =>$tags,
          'weightage_type'=>$request->get('weightage_type'),
          'options'          =>json_encode($options),
          'question_type'=>$request->get('question_type'),
          'optiontype'=>$request->get('optiontype'),
          'ans'          =>$request->get('ans'),
          'notes'        =>$request->get('notes'),
          'explanation'  =>$request->get('explanation')
      ]);

    
     $this->meesage('message','Questions Updated successfully!');
      //return redirect()->back();
      return redirect('questions');

    } 
   public function deletequestion(Request $request, Questions $question){
   	
   	if($question->used_status==0){
      $question->status ="2";
      $question->update();
      $this->meesage('message','Questions Updated Successfully!');
   	}else{
   		$this->meesage('message','Unable to Delete Question in used!');
   	}
   	
    
    return redirect('questions');
   }
   public function meesage(string $name = null, string $message = null)
    {
        return session()->flash($name,$message);
    }
}
